/**
 * 
 */
package gov.va.med.mhv.usermgmt.web.controller;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.web.formbean.ChangePassword;

import java.io.IOException;
import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
/**
 * @author PII
 * 
 */
@ManagedBean
@Component
@Scope("session")
public class ChangeTemporayPasswordController extends AbstractController implements
		Serializable {

	private static final long serialVersionUID = -9191875686222494443L;

	static Log logger = LogFactoryUtil
			.getLog(ChangeTemporayPasswordController.class);

	
	private ChangePassword changePassword = new ChangePassword();

	private String successMessage = null;
	
	
	private String changeMessage="show";




	
	public void viewControl(ComponentSystemEvent event) {
		
		PortletRequest request = (PortletRequest) FacesContext
				.getCurrentInstance().getExternalContext().getRequest();
	
		if (request.getUserPrincipal() == null) {
			FacesContext context = FacesContext.getCurrentInstance();
			context.getApplication().getNavigationHandler()
					.handleNavigation(context, null, "uanuthorized.xhtml");
		} 
		if (FacesContext.getCurrentInstance().isPostback()) {
			changeMessage=null;
		}
	}

	public String updatePassword() {
		FacesContext context = FacesContext.getCurrentInstance();

		logger.info("========inside update Temporary Password()============ " + getUserScreenName());

		
		UserProfileDTO userProfile = getUserProfile(getUserScreenName());
		userProfile.setPassword(this.changePassword.getNewPassword());
		userProfile.setConfPassword(this.changePassword.getConfirmNewPassword());
		userProfile.setOldPassword(this.changePassword.getCurrentPassword());
		validatePassword(userProfile,true);
		
		if( FacesContext.getCurrentInstance().getMessageList().size() > 0 ) {
			return null;
		}

		try {
			logger.debug("ChangeTempPasswordController - savePassword start");
			
			this.userMgmtService.changeTemporaryPassword(userProfile,Boolean.FALSE);
			
			logger.debug("ChangeTempPasswordController - savePassword -success");
			
			this.successMessage = "success";
			
		} catch (MHVException e) {
			super.processErrorMessages(e);
			return null;
		} catch (Exception e) {
			this.successMessage = "failure";
			logger.debug("ChangeTempPasswordController - savePassword - fail");
			logger.debug("ChangeTempPasswordController - exception "
					+ e.getMessage());
			
			logger.error(e);
			
		}

		logger.info("successMessage : " + successMessage);

		try {
			context.getExternalContext().redirect(getHomeURL());
		} catch (IOException e) {
			
			
		}
		
		return null;
	}


	public ChangePassword getChangePassword() {
		return changePassword;
	}

	public void setChangePassword(ChangePassword changePassword) {
		this.changePassword = changePassword;
	}
	

	public String getSuccessMessage() {
		return successMessage;
	}

	public String getChangeMessage() {
		return changeMessage;
	}

	public void setChangeMessage(String changeMessage) {
		this.changeMessage = changeMessage;
	}

}